% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_strat.R
\name{sample_strat}
\alias{sample_strat}
\title{Stratified sampling}
\usage{
sample_strat(
  sraster,
  nSamp,
  allocation = "prop",
  method = "Queinnec",
  weights = NULL,
  force = FALSE,
  mraster = NULL,
  mindist = NULL,
  existing = NULL,
  include = FALSE,
  remove = FALSE,
  access = NULL,
  buff_inner = NULL,
  buff_outer = NULL,
  wrow = 3,
  wcol = 3,
  plot = FALSE,
  details = FALSE,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{sraster}{spatRaster. Stratification raster to be used for sampling.}

\item{nSamp}{Numeric. Number of desired samples. \code{existing}, \code{include} and \code{force} influence this value.}

\item{allocation}{Character. Allocation algorithm to be used. Either \code{prop} (default) for proportional allocation,
\code{optim} for optimal allocation (equal sampling cost), \code{equal} for equal number of samples (defined by \code{nSamp})
for each strata, or \code{"manual"} for user defined strata weights defined using \code{weights}.}

\item{method}{Character. Sampling design approach \code{"Queinnec"} (default) or \code{"random"}. \code{"Queinnec"} method is
described in notes below. \code{"random"} performs traditional stratified random sampling where probability to sample each
cell within each stratum is equal assuming default parameters for \code{mindist}. \code{existing, include, remove} are ignored when \code{method = "random"}.}

\item{weights}{Numeric. Only applicable when \code{allocation = "manual"}. Vector of weights where \code{sum(weights) == 1}. Vector length
must be equal to the number of unique strata where the first numeric value corresponds to stratum 1, second stratum 2 etc.}

\item{force}{Logical. \code{Default = FALSE} - force \code{nSamp} to be exactly the user defined value
in cases where \code{nSamp} and \code{sraster} strata count are not equally divisible. Additional samples often need to be allocated or removed
based on rounding differences resulting from proportional differences between \code{nSamp} and strata coverages in \code{sraster}.
In these instances samples are either added to strata with the lowest number of samples or are removed from strata with the highest number of samples.
Has no effect when \code{existing} is provided.}

\item{mraster}{spatRaster. ALS metric raster. Required when \code{allocation = optim}.}

\item{mindist}{Numeric. Minimum allowable distance between selected
samples. \code{Default = NULL}.}

\item{existing}{sf 'POINT' or data.frame.  Existing plot network.}

\item{include}{Logical. If \code{TRUE} include \code{existing} plots in \code{nSamp} total.}

\item{remove}{Logical. If \code{TRUE} randomly remove samples from over represented strata to meet allocated sample numbers.
Used only when \code{existing} and \code{include} are both \code{TRUE}.}

\item{access}{sf 'LINESTRING' or 'MULTILINESTRING'. Access network.}

\item{buff_inner}{Numeric. Inner buffer boundary specifying distance
from access where plots cannot be sampled.}

\item{buff_outer}{Numeric. Outer buffer boundary specifying distance
from access where plots can be sampled.}

\item{wrow}{Numeric. Number of row in the focal window (\code{default = 3}).}

\item{wcol}{Numeric. Number of columns in the focal window (\code{default = 3}).}

\item{plot}{Logical. Plots samples of type `existing` (if provided; croses) and `new` (circles) along with \code{sraster}.}

\item{details}{Logical. If \code{FALSE} (default) output is sf object of
stratified samples. If \code{TRUE} return a list
where \code{$details} additional sampling information and \code{$raster}
is an sf object of stratified samples.}

\item{filename}{Character. Path to write output samples.}

\item{overwrite}{Logical. Choice to overwrite existing \code{filename} if it exists.}
}
\value{
An sf object with \code{nSamp} stratified samples.
}
\description{
Sampling based on a stratified raster.
}
\note{
The sampling is performed in 2 stages when \code{method = "Queinnec"}:
\enumerate{

\item \code{Rule 1} - Sample within grouped stratum pixels defined within the
\code{wrow, wcol} parameters

\item \code{Rule 2} - If no samples exist to satisfy Rule 1
 individual stratum pixels are sampled.

 The rule applied to allocate each sample is defined in the \code{rule} attribute of output samples.

}

\code{existing} may contain samples that fall in \code{sraster} cells that are `NA`. If this occurs and \code{include = TRUE}, `NA` samples
are separated during sampling and re-appended at the end of the sampling process.

If the \code{sraster} provided contains factor values, the algorithm will automatically convert these into the numeric factor levels and 
perform sampling using those values. The categories (factor values) will be extracted and appended to the algorithm output as the `category` attribute.
}
\examples{
#--- Load raster and access files ---#
r <- system.file("extdata", "sraster.tif", package = "sgsR")
sr <- terra::rast(r)


#--- perform stratified sampling random sampling ---#
sraster <- sample_strat(
  sraster = sr,
  nSamp = 50
)


}
\references{
Queinnec, M., White, J. C., & Coops, N. C. (2021).
Comparing airborne and spaceborne photon-counting LiDAR canopy
structural estimates across different boreal forest types.
Remote Sensing of Environment, 262 (August 2020), 112510.
https://doi.org/10.1016/j.rse.2021.112510
}
\seealso{
Other sample functions: 
\code{\link{sample_ahels}()},
\code{\link{sample_balanced}()},
\code{\link{sample_clhs}()},
\code{\link{sample_nc}()},
\code{\link{sample_srs}()},
\code{\link{sample_systematic}()}
}
\author{
Tristan R.H. Goodbody & Martin Queinnec
}
\concept{sample functions}
