% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-existing.R
\name{prepare_existing}
\alias{prepare_existing}
\title{Prepare existing sample data}
\usage{
prepare_existing(
  existing,
  raster = NULL,
  access = NULL,
  buff_inner = NULL,
  buff_outer = NULL
)
}
\arguments{
\item{existing}{sf 'POINT'.  Existing plot network.}

\item{raster}{SpatRaster. Raster to guide the location of the samples. If \code{type = "clhs"} this raster can also
be used to define the population distributions to be used for sampling.}

\item{access}{sf. Road access network - must be lines.}

\item{buff_inner}{Numeric. Inner buffer boundary specifying distance
from access where plots cannot be sampled.}

\item{buff_outer}{Numeric. Outer buffer boundary specifying distance
from access where plots can be sampled.}
}
\description{
This function prepares the existing sample data by ensuring that it meets the necessary requirements for downstream analysis.
If the 'existing' object is not of class 'sf', this function checks that the data contains columns named "X" and "Y", and
converts lowercase "x" and "y" column names to uppercase if necessary. If the 'raster' object is supplied, this function
checks if 'existing' contains attributes with the same names as 'raster'. If it does not, this function extracts metrics
at existing sample locations using the 'raster' object. If 'access' is not null, the function masks the existing sample
locations with a buffered access area.
}
\keyword{internal}
