% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{saturation}
\alias{saturation}
\alias{brightness}
\alias{lightness}
\alias{chroma}
\alias{hue}
\alias{delta}
\title{Query or change colour properties}
\usage{
saturation(shades, values = NULL)

brightness(shades, values = NULL)

lightness(shades, values = NULL)

chroma(shades, values = NULL)

hue(shades, values = NULL)

delta(values)
}
\arguments{
\item{shades}{One or more colours, in any suitable form (see
\code{\link{shade}}).}

\item{values}{New values for the property in question. If \code{NULL}, the
current value(s) will be returned. May also be a function computing new
values from old ones, notably \code{delta}, which adds its argument.}
}
\value{
Current colour property values, or new colours of class
  \code{"shade"}.
}
\description{
These functions obtain the value of a colour property, or modify it. They
will convert between colour spaces as required, but the RGB representation
will be appropriately updated in the result.
}
\details{
Brightness and lightness differ technically, in the sense that one is
absolute and the other is relative. Intuitively, a grey square on white
paper is brighter under bright sunlight than in a dark room, but its
lightness (relative to the white around it) is constant between conditions.
In these functions, brightness is ``value'' in HSV space and is between 0
and 1, while lightness is defined in Lab space and is between 0 and 100.
Saturation and chroma are also related. Hue is defined in HSV space, with
red at 0º (and 360º), which is generally the most familiar parameterisation.
}
\examples{
saturation(c("papayawhip","lavenderblush","olivedrab"))
saturation("papayawhip", 0.7)
saturation("papayawhip", delta(0.2))
}
\author{
Jon Clayden <code@clayden.org>
}
