% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGrid.R
\name{plotGrid}
\alias{plotGrid}
\title{Interactive plot for 3D spatial points}
\usage{
plotGrid(grid, color = c("grey", "red")[as.factor(grid$type)], size = 0.2, ...)
}
\arguments{
\item{grid}{A three-dimensional \code{SpatialPoints*} object}

\item{color}{Point color, either a single value or vector corresponding to the number of points. The default values draws "facade" and "roof" points in different colors, assuming these classes appear in a column named \code{type}, as returned by function \code{\link{surfaceGrid}}}

\item{size}{Point radius, default is \code{0.1}}

\item{...}{Additional parameters passed to \code{scatterplot3js}}
}
\value{
An htmlwidget object that is displayed using the object's show or print method. If you don't see your widget plot, try printing it with the print function. (Same as for \code{threejs::scatterplot3js})
}
\description{
This is a wrapper around \code{scatterplot3js} from package \code{threejs}. The function adjusts the x, y and z axes so that 1:1:1 proportion are kept and z=0 corresponds to ground level.
}
\examples{
\dontrun{
grid = surfaceGrid(
  obstacles = build,
  obstacles_height_field = "BLDG_HT",
  res = 1,
  offset = 0.01
)
plotGrid(grid)
}

}
