% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.mass.R
\name{mass.algorithm}
\alias{mass.algorithm}
\title{Mass Selection Algorithm}
\usage{
mass.algorithm(mass, pc, vr, n, w = c(1, 1, 1), two.stage = TRUE)
}
\arguments{
\item{mass}{a vector of mass values}

\item{pc}{a vector of partition confidences for the partition estimates at
the corresponding mass values}

\item{vr}{a vector of variance ratios for the partition estimates at the
corresponding mass values}

\item{n}{a vector of the number of subsets in the partition estimates at the
correpsonding mass values}

\item{w}{a vector of length 3 specifying the weights of \code{pc}, \code{vr},
and \code{n}}

\item{two.stage}{logical; if \code{TRUE}, the two stage algorithm is
implemented}
}
\value{
A matrix containing the `best' \code{mass} value and corresponding
  values for \code{pc}, \code{vr}, and \code{n}. The matrix also contains the
  mass values for the partitions estimate with more one more and one less
  subset that the selected mass value.
}
\description{
This function selects the optimal mass value for Cluster Analysis via Random
Partition distributions using the Ewens-Pitman attraction distribution.
}
\details{
The \code{\link{mass.algorithm}} function is used internally in the
\code{\link{default.mass}} function.

The default value for \code{w} is \code{c(1,1,1)}.

The general algorithm is as follows: \enumerate{ \item Rank the partition
confidence (\code{pc}) and variance ratio (\code{vr}). Select the
\code{mass_i} value which minimizes the weigthed sum of \eqn{w_1 pc_i + w_2
vr_i + w_3 n_i}. }

The two stage algorithm proceeds as follows: \enumerate{ \item Rank the
partition confidence (\code{pc}) and variance ratio (\code{vr}). For each
number of clusters \code{n} select the index which minimizes the weigthed sum
of \eqn{w_1 pc_i + w_2 vr_i}. \item Rerank the \code{pc} and \code{vr} of the
selected indices and select the \code{mass_i} value which minimizes the
weigthed sum of \eqn{w_1 pc_i + w_2 vr_i + w_3 n_i} from among the selected
indices. }
}
\seealso{
Other Default Mass Selection: 
\code{\link{default.mass}()},
\code{\link{partition.confidence}()},
\code{\link{variance.ratio}()}
}
\concept{Default Mass Selection}
