% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac_torch_modules.R
\name{gauss_cat_loss}
\alias{gauss_cat_loss}
\title{A \code{\link[torch:nn_module]{torch::nn_module()}} Representing a \code{gauss_cat_loss}}
\usage{
gauss_cat_loss(one_hot_max_sizes, min_sigma = 1e-04, min_prob = 1e-04)
}
\arguments{
\item{one_hot_max_sizes}{A torch tensor of dimension \code{n_features} containing the one hot sizes of the \code{n_features}
features. That is, if the \code{i}th feature is a categorical feature with 5 levels, then \code{one_hot_max_sizes[i] = 5}.
While the size for continuous features can either be \code{0} or \code{1}.}

\item{min_sigma}{For stability it might be desirable that the minimal sigma is not too close to zero.}

\item{min_prob}{For stability it might be desirable that the minimal probability is not too close to zero.}
}
\description{
The \verb{gauss_cat_loss module} layer computes the log probability of the \code{groundtruth} for each object
given the mask and the distribution parameters. That is, the log-likelihoods of the true/full training observations
based on the generative distributions parameters \code{distr_params} inferred by the masked versions of the observations.
}
\details{
Note that the module works with mixed data represented as 2-dimensional inputs and it
works correctly with missing values in \code{groundtruth} as long as they are represented by NaNs.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
