% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac_torch_modules.R
\name{vaeac_normalize_data}
\alias{vaeac_normalize_data}
\title{Normalize mixed data for \code{vaeac}}
\usage{
vaeac_normalize_data(
  data_torch,
  one_hot_max_sizes,
  norm_mean = NULL,
  norm_std = NULL
)
}
\arguments{
\item{one_hot_max_sizes}{A torch tensor of dimension \code{n_features} containing the one hot sizes of the \code{n_features}
features. That is, if the \code{i}th feature is a categorical feature with 5 levels, then \code{one_hot_max_sizes[i] = 5}.
While the size for continuous features can either be \code{0} or \code{1}.}

\item{norm_mean}{Torch tensor (optional). A 1D array containing the means of the columns of \code{x_torch}.}

\item{norm_std}{Torch tensor (optional). A 1D array containing the stds of the columns of \code{x_torch}.}
}
\value{
A list containing the normalized version of \code{x_torch}, \code{norm_mean} and \code{norm_std}.
}
\description{
Compute the mean and std for each continuous feature, while the categorical features will have mean 0 and std 1.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
