\name{PLSS2LL}
\alias{PLSS2LL}
\alias{PLSS2LL_1}

\title{PLSS2LL}
\description{Fetch lattitude and longitude centroid coordinates for coded PLSS information from the BLM PLSS web service.}
\usage{PLSS2LL(p)}

\arguments{
  \item{p}{dataframe with chunks of PLSS coordinates}
}
\details{This function takes coded PLSS information and fetches the centroid lat/long coordinates down to the quarter-quarter section.  The 'plssid' column is generated within a dataframe using the following \code{\link{formatPLSS}} function.}
\value{A dataframe of PLSS codes and coordinates.}
\author{D.E. Beaudette, Jay Skovlin}
\note{This function expects that the dataframe will have a 'plssid' column generated by the \code{formatPLSS} function. Requires the following packages: \code{httr}, and \code{jsonlite}.}

\seealso{\code{\link{LL2PLSS}}, \code{\link{formatPLSS}}}

\examples{
\donttest{

if(requireNamespace("curl") &
   curl::has_internet()
   ) {
  
  
# create some data
d <- data.frame( 
id=1:3, 
qq=c('SW', 'SW', 'SE'), 
q=c('NE', 'NW', 'SE'),
s=c(17, 32, 30), 
t=c('T36N', 'T35N', 'T35N'),
r=c('R29W', 'R28W', 'R28W'),
type='SN',
m='MT20', stringsAsFactors = FALSE)

# add column names
names(d) <- c('id', 'qq', 'q', 's', 't', 'r', 'type', 'm')

# generate formatted PLSS codes
d$plssid <- formatPLSS(d)

# fetch lat/long coordinates
PLSS2LL(d)
  
}

}
}

\keyword{manip}
