% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info-box.R
\name{flip_box}
\alias{flip_box}
\alias{flip}
\title{An 'HTML' container that can flip}
\usage{
flip_box(
  front,
  back,
  active_on = c("click", "click-front", "manual"),
  inputId = NULL,
  class = NULL
)

flip(inputId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{front}{'HTML' elements to show in the front}

\item{back}{'HTML' elements to show when the box is flipped}

\item{active_on}{the condition when a box should be flipped; choices are
\code{'click'}: flip when double-click on both sides; \code{'click-front'}:
only flip when the front face is double-clicked; \code{'manual'}: manually
flip in \code{R} code (see \code{{flip(inputId)}} function)}

\item{inputId}{element 'HTML' id; must be specified if \code{active_on} is
not \code{'click'}}

\item{class}{'HTML' class}

\item{session}{shiny session; default is current active domain}
}
\value{
\code{flip_box} returns 'HTML' tags; \code{flip} should be called
from shiny session, and returns nothing
}
\description{
An 'HTML' container that can flip
}
\examples{

# More examples are available in demo

library(shiny)
library(shidashi)

session <- MockShinySession$new()

flip_box(front = info_box("Side A"),
         back = info_box("Side B"),
         inputId = 'flip_box1')

flip('flip_box1', session = session)

}
