% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R,
%   R/inputs.R
\name{CompactPeoplePicker}
\alias{CompactPeoplePicker}
\alias{NormalPeoplePicker}
\alias{PeoplePicker}
\alias{NormalPeoplePicker.shinyInput}
\alias{updateNormalPeoplePicker.shinyInput}
\title{PeoplePicker}
\usage{
CompactPeoplePicker(...)

NormalPeoplePicker(...)

NormalPeoplePicker.shinyInput(inputId, ..., value = defaultValue)

updateNormalPeoplePicker.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
The update functions return nothing (called for side effects).
}
\description{
The people picker (\code{PeoplePicker}) is used to select one or more entities, such as people or groups, from a list. It makes composing an email to someone, or adding them to a group, easy if you don’t know their full name or email address.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/PeoplePicker}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<IPeoplePickerItemSelectedStyleProps, IPeoplePickerItemSelectedStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.}
\item {\bold{ ValidationState }} {\code{ValidationState} \cr }
\item {\bold{ className }} {\code{string} \cr Additional CSS class(es) to apply to the PeoplePickerItem root element.}
\item {\bold{ theme }} {\code{ITheme} \cr Theme provided by High-Order Component.}
\item {\bold{ compact }} {\code{boolean} \cr Flag that controls whether each suggested PeoplePicker item (Persona) is rendered with or without secondary text for compact look.}
\item {\bold{ personaProps }} {\code{IPersonaProps} \cr Persona props for each suggested for picking PeoplePicker item.}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<IPeoplePickerItemSuggestionStyleProps, IPeoplePickerItemSuggestionStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.}
\item {\bold{ suggestionsProps }} {\code{IBasePickerSuggestionsProps} \cr General common props for all PeoplePicker items suggestions.}
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Use the people picker to add someone to the To line of an email, or to add someone to a list.
\item Use the \verb{MemberList PeoplePicker} to display selections below the input field.
}
}
}

\examples{
library(shiny.fluent)

assetsUrl <- "https://static2.sharepointonline.com/files/fabric/office-ui-fabric-react-assets/"
malePersonaUrl <- paste0(assetsUrl, "persona-male.png")
femalePersonaUrl <- paste0(assetsUrl, "persona-female.png")

people <- tibble::tibble(
  key = c(1, 2, 3, 4, 5, 6, 7),
  imageUrl = c(
    femalePersonaUrl,
    malePersonaUrl,
    malePersonaUrl,
    malePersonaUrl,
    malePersonaUrl,
    femalePersonaUrl,
    malePersonaUrl
  ), 
  imageInitials = c("PV", "AR", "AL", "RK", "CB", "VL", "MS"),
  text = c(
    "Annie Lindqvist",
    "Aaron Reid",
    "Alex Lundberg",
    "Roko Kolar",
    "Christian Bergqvist",
    "Valentina Lovric",
    "Maor Sharett"
  ),
  secondaryText = c(
    "Designer",
    "Designer",
    "Software Developer",
    "Financial Analyst",
    "Sr. Designer",
    "Design Developer",
    "UX Designer"
  ),
  tertiaryText = c(
    "In a meeting",
    "In a meeting",
    "In a meeting",
    "In a meeting",
    "In a meeting",
    "In a meeting",
    "In a meeting"
  ),
  optionalText = c(
    "Available at 4:00pm",
    "Available at 4:00pm",
    "Available at 4:00pm",
    "Available at 4:00pm",
    "Available at 4:00pm",
    "Available at 4:00pm",
    "Available at 4:00pm"
  ),
  isValid = c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE),
  presence = c(2, 6, 4, 1, 2, 2, 3),
  canExpand = c(NA, NA, NA, NA, NA, NA, NA)
)

if (interactive()) {
  shinyApp(
    ui = tagList(
      textOutput("selectedPeople"),
      NormalPeoplePicker.shinyInput(
        "selectedPeople",
        options = people,
        pickerSuggestionsProps = list(
          suggestionsHeaderText = 'Matching people',
          mostRecentlyUsedHeaderText = 'Sales reps',
          noResultsFoundText = 'No results found',
          showRemoveButtons = TRUE
        )
      )
    ),
    server = function(input, output) {
      output$selectedPeople <- renderText({
        if (length(input$selectedPeople) == 0) {
          "Select recipients below:"
        } else {
          selectedPeople <- dplyr::filter(people, key \%in\% input$selectedPeople)
          paste("You have selected:", paste(selectedPeople$text, collapse=", "))
        }
      })
    }
  )
}
}
