% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.R
\name{list_container}
\alias{list_container}
\title{Create Semantic UI list with header, description and icons}
\usage{
list_container(content_list, is_divided = FALSE)
}
\arguments{
\item{content_list}{list of lists with fields: `header` and/or `description`,
`icon` containing the list items headers, descriptions (one of these is mandatory)
and icons. Icon column should contain strings with icon names available
here: https://fomantic-ui.com/elements/icon.html}

\item{is_divided}{If TRUE created list elements are divided}
}
\description{
This creates a list with icons using Semantic UI
}
\examples{
library(shiny)
library(shiny.semantic)
list_content <- list(
  list(header = "Head", description = "Lorem ipsum", icon = "cat"),
  list(header = "Head 2", icon = "tree"),
  list(description = "Lorem ipsum 2", icon = "dog")
)
if (interactive()){
  ui <- semanticPage(
    list_container(list_content, is_divided = TRUE)
 )
  server <- function(input, output) {}
  shinyApp(ui, server)
}

}
