% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating.R
\name{rating_input}
\alias{rating_input}
\title{Rating Input.}
\usage{
rating_input(
  input_id,
  label = "",
  value = 0,
  max = 3,
  icon = "star",
  color = "yellow",
  size = ""
)
}
\arguments{
\item{input_id}{The \code{input} slot that will be used to access the value.}

\item{label}{the contents of the item to display}

\item{value}{initial rating value}

\item{max}{maximum value}

\item{icon}{character with name of the icon or \code{\link{icon}()} that is
an element of the rating}

\item{color}{character with colour name}

\item{size}{character with legal semantic size, eg. "medium", "huge", "tiny"}
}
\value{
rating object
}
\description{
Crates rating component
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
  library(shiny)
  library(shiny.semantic)

  ui <- shinyUI(
    semanticPage(
      rating_input("rate", "How do you like it?", max = 5,
                   icon = "heart", color = "yellow"),
    )
  )
  server <- function(input, output) {
    observeEvent(input$rate,{print(input$rate)})
  }
  shinyApp(ui = ui, server = server)
}
}
