% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{validate}
\alias{validate}
\alias{need}
\title{Validate input values and other conditions}
\usage{
validate(..., errorClass = character(0))

need(expr, message = paste(label, "must be provided"), label)
}
\arguments{
\item{...}{A list of tests. Each test should equal \code{NULL} for success,
\code{FALSE} for silent failure, or a string for failure with an error
message.}

\item{errorClass}{A CSS class to apply. The actual CSS string will have
\verb{shiny-output-error-} prepended to this value.}

\item{expr}{An expression to test. The condition will pass if the expression
meets the conditions spelled out in Details.}

\item{message}{A message to convey to the user if the validation condition is
not met. If no message is provided, one will be created using \code{label}.
To fail with no message, use \code{FALSE} for the message.}

\item{label}{A human-readable name for the field that may be missing. This
parameter is not needed if \code{message} is provided, but must be provided
otherwise.}
}
\description{
\code{validate()} provides convenient mechanism for validating that an output
has all the inputs necessary for successful rendering. It takes any number
of (unnamed) arguments, each representing a condition to test. If any
of condition fails (i.e. is not \link[=isTruthy]{"truthy"}), a special type of
error is signaled to stop execution. If this error is not handled by
application-specific code, it is displayed to the user by Shiny.

If you use \code{validate()} in a \code{\link[=reactive]{reactive()}} validation failures will
automatically propagate to outputs that use the reactive.
}
\section{\code{need()}}{

An easy way to provide arguments to \code{validate()} is to use \code{need()}, which
takes an expression and a string. If the expression is not
\link[=isTruthy]{"truthy"} then the string will be used as the error message.

If "truthiness" is flexible for your use case, you'll need to explicitly
generate a logical values. For example, if you want allow \code{NA} but not
\code{NULL}, you can \code{!is.null(input$foo)}.

If you need validation logic that differs significantly from \code{need()}, you
can create your own validation test functions. A passing test should return
\code{NULL}. A failing test should return either a string providing the error
to display to the user, or if the failure should happen silently, \code{FALSE}.

Alternatively you can use \code{validate()} within an \code{if} statement, which is
particularly useful for more complex conditions:\preformatted{if (input$x < 0 && input$choice == "positive") \{
  validate("If choice is positive then x must be greater than 0")
\}
}
}

\examples{
## Only run examples in interactive R sessions
if (interactive()) {
options(device.ask.default = FALSE)

ui <- fluidPage(
  checkboxGroupInput('in1', 'Check some letters', choices = head(LETTERS)),
  selectizeInput('in2', 'Select a state', choices = c("", state.name)),
  plotOutput('plot')
)

server <- function(input, output) {
  output$plot <- renderPlot({
    validate(
      need(input$in1, 'Check at least one letter!'),
      need(input$in2 != '', 'Please choose a state.')
    )
    plot(1:10, main = paste(c(input$in1, input$in2), collapse = ', '))
  })
}

shinyApp(ui, server)

}
}
