% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{isTruthy}
\alias{isTruthy}
\title{Truthy and falsy values}
\usage{
isTruthy(x)
}
\arguments{
\item{x}{An expression whose truthiness value we want to determine}
}
\description{
The terms "truthy" and "falsy" generally indicate whether a value, when
coerced to a \code{\link[base:logical]{base::logical()}}, is \code{TRUE} or \code{FALSE}. We use
the term a little loosely here; our usage tries to match the intuitive
notions of "Is this value missing or available?", or "Has the user provided
an answer?", or in the case of action buttons, "Has the button been
clicked?".
}
\details{
For example, a \code{textInput} that has not been filled out by the user has
a value of \code{""}, so that is considered a falsy value.

To be precise, a value is truthy \emph{unless} it is one of:
\itemize{
\item \code{FALSE}
\item \code{NULL}
\item \code{""}
\item An empty atomic vector
\item An atomic vector that contains only missing values
\item A logical vector that contains all \code{FALSE} or missing values
\item An object of class \code{"try-error"}
\item A value that represents an unclicked \code{\link[=actionButton]{actionButton()}}
}

Note in particular that the value \code{0} is considered truthy, even though
\code{as.logical(0)} is \code{FALSE}.
}
