% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyCohortBuilder-package.R
\name{source-gui-layer}
\alias{source-gui-layer}
\title{Source compatibility methods.}
\value{
Various type outputs dependent on the selected method.
  See each method documentation for details.
}
\description{
List of methods that allow compatibility of different source types.
Most of the methods should be defined in order to make new source layer functioning.
See 'Details' section for more information.
}
\details{
The package is designed to make the functionality work with multiple data sources.
Data source can be based for example on list of tables, connection to database schema
or API service that allows to access and operate on data.
In order to make new source type layer functioning, the following list of methods
should be defined:
\itemize{
  \item{\code{.render_filters}}
  \item{\code{.update_data_stats}}
  \item{\code{.step_attrition}}
  \item{\code{.custom_attrition}}
  \item{\code{.available_filter_choices}}
  \item{\code{autofilter}}
}
Except from the above methods, you may extend the existing or new source with providing
custom gui filtering methods. See \link{gui-filter-layer}.
In order to see more details about how to implement custom source check `vignette("custom-gui-layer")`.
}
