% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildIoptions.R
\name{buildIOptions}
\alias{buildIOptions}
\title{buildIOptions}
\usage{
buildIOptions(
  minZoom = 1e-50,
  maxZoom = 1e+50,
  zoomingEnabled = TRUE,
  userZoomingEnabled = TRUE,
  panningEnabled = TRUE,
  userPanningEnabled = TRUE,
  boxSelectionEnabled = TRUE,
  selectionType = "single",
  autolock = FALSE,
  autoungrabify = FALSE,
  autounselectify = FALSE
)
}
\arguments{
\item{minZoom}{Minimal zoom level of canvas. [numeric]}

\item{maxZoom}{Maximal zoom level of canvas. [numeric]}

\item{zoomingEnabled}{Whether canvas can zoom or not. by both user event and programmatically. [logical]}

\item{userZoomingEnabled}{Whether canvas can zoom or not. by user event. [logical]}

\item{panningEnabled}{Whether canvas can move or not. by both user event and programmatically. [logical]}

\item{userPanningEnabled}{Whether canvas can move or not. by user event. [logical]}

\item{boxSelectionEnabled}{Whether box selection by drag available [logical]}

\item{selectionType}{Indicate selection by user input is addtive or single(default). ['single' or 'addtivie']}

\item{autolock}{Whether nodes should be locked (not draggable at all) by default (if true, overrides individual node state). [logical]}

\item{autoungrabify}{Whether nodes should be ungrabified (not grabbable by user) by default (if true, overrides individual node state). [logical]}

\item{autounselectify}{Whether nodes should be unselectified (immutable selection state) by default (if true, overrides individual element state). [logical]}
}
\value{
List typed Interact Option for Cytoscape.js canvas object.
}
\description{
build Interact Option
}
\details{
undescribed parameter will set as default. note that touchTapThreshold & desktopTapThreshold were not used.
}
\examples{
iopt = buildIOptions(
minZoom = 0.001, maxZoom = 3, zoomingEnabled = TRUE,
userZoomingEnabled = FALSE, panningEnabled = TRUE, userPanningEnabled = TRUE,
boxSelectionEnabled = FALSE, selectionType = 'single', autolock = FALSE,
autoungrabify = TRUE, autounselectify = FALSE)

}
\seealso{
https://js.cytoscape.org/#core/initialisation
}
