% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_logging_session.R
\name{set_logging_session}
\alias{set_logging_session}
\title{Session-specific settings for event logging}
\usage{
set_logging_session(...)
}
\arguments{
\item{...}{a set of named objects
 (usually of type character, numeric, or date)
to be logged as parameters common to all events.}
}
\description{
\code{set_logging_session} should be used at the beginning
of the shiny server function to define session-specific event parameters.
\code{set_logging_session} also sets event counter to 1.
}
\details{
\code{set_logging_session} assigns to the parent frame new environment:
\code{log_settings_session} for storing session-specific event parameters
and information about multiple
instances of the same event (see \code{\link{log_started}}).
}
\examples{
if (interactive()) {

  set_logging()
  shiny::shinyApp(
    ui = shiny::fluidPage(log_init()),
    server = function(input, output) {
      set_logging_session(
        session_id = shiny::getDefaultReactiveDomain()$token
        )
      log_event("Event 1 with session parameter")
      log_event("Event 2 with session parameter")
    }
  )
  # You can open app in the browser and duplicate tab to see different
  # unique session ids in event parameters.
}
}
\seealso{
Other setting up logging parameters functions: \code{\link{log_params}},
  \code{\link{set_logging}}
}
\concept{setting up logging parameters functions}
