% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Messages.R
\name{f7Messages}
\alias{f7Messages}
\title{Create a Framework7 messages container}
\usage{
f7Messages(..., id)
}
\arguments{
\item{...}{Slot for \link{f7Message}.}

\item{id}{Container id.}
}
\description{
Create a Framework7 messages container
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     preloader = FALSE,
     title = "My app",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7Messages"),
       f7Messages(
         id = "messagelist",
         f7Message(
           "Lorem ipsum dolor sit amet,
           consectetur adipiscing elit.
           Duo Reges: constructio interrete",
           src = "https://cdn.framework7.io/placeholder/people-100x100-7.jpg",
           author = "David",
           date = "2019-09-12",
           state = "received",
           type = "text"
         ),
         f7Message(
           "https://cdn.framework7.io/placeholder/cats-200x260-4.jpg",
           src = "https://cdn.framework7.io/placeholder/people-100x100-9.jpg",
           author = "Lia",
           date = NULL,
           state = "sent",
           type = "img"
         ),
         f7Message(
           "Hi Bro",
           src = "https://cdn.framework7.io/placeholder/people-100x100-9.jpg",
           author = NULL,
           date = "2019-08-15",
           state = "sent",
           type = "text"
         )
       )
     )
   ),
   server = function(input, output, session) {
   }
 )
}
}
