% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Shadow.R
\name{f7Shadow}
\alias{f7Shadow}
\title{Create a Framework7 shadow effect}
\usage{
f7Shadow(tag, intensity, hover = FALSE, pressed = FALSE)
}
\arguments{
\item{tag}{Tag to apply the shadow on.}

\item{intensity}{Shadow intensity. Numeric between 1 and 24. 24 is the highest elevation.}

\item{hover}{Whether to display the shadow on hover. FALSE by default.}

\item{pressed}{Whether to display the shadow on click. FALSE by default.}
}
\description{
Build a Framework7 shadow effect
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
    title = "Shadows",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Shadow"),
     f7Shadow(
     intensity = 16,
     hover = TRUE,
     pressed = TRUE,
     f7Card(
      title = "Card header",
      "This is a simple card with plain text,
       but cards can also contain their own header,
       footer, list view, image, or any other element.",
      footer = tagList(
       f7Button(color = "blue", label = "My button", src = "https://www.google.com"),
       f7Badge("Badge", color = "green")
      )
     )
    )
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
