% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7List.R
\name{f7ListIndex}
\alias{f7ListIndex}
\title{Create a Framework 7 list index}
\usage{
f7ListIndex(..., id)
}
\arguments{
\item{...}{Slot for \link{f7ListGroup}.}

\item{id}{Unique id.}
}
\description{
Create a Framework 7 list index
}
\note{
For some reason, unable to get more than 1 list index working. See
example below. The second list does not work.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "List Index",
     f7TabLayout(
       navbar = f7Navbar(
         title = "f7ListIndex",
         hairline = FALSE,
         shadow = TRUE
       ),
       f7Tabs(
         f7Tab(
           tabName = "List 1",
           f7ListIndex(
             id = "listIndex1",
             lapply(seq_along(LETTERS), function(i) {
               f7ListGroup(
                 title = LETTERS[i],
                 lapply(1:3, function(j) {
                   f7ListIndexItem(letters[j])
                 })
               )
             })
           )
         ),
         f7Tab(
           tabName = "List 2",
           f7ListIndex(
             id = "listIndex2",
             lapply(seq_along(LETTERS), function(i) {
               f7ListGroup(
                 title = LETTERS[i],
                 lapply(1:3, function(j) {
                   f7ListIndexItem(letters[j])
                 })
               )
             })
           )
         )
       )
     )
   ),
   server = function(input, output) {}
 )
}
}
