% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7TextArea}
\alias{f7TextArea}
\alias{updateF7TextArea}
\title{Framework7 text area input}
\usage{
f7TextArea(inputId, label, value = "", placeholder = NULL, resize = FALSE)

updateF7TextArea(
  inputId,
  label = NULL,
  value = NULL,
  placeholder = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{placeholder}{The placeholder to set for the input object.}

\item{resize}{Whether to box can be resized. Default to FALSE.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
\code{f7TextArea} creates a f7 text area input.

\code{updateF7TextArea} changes the value of a text area input on the client.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7TextArea(
      inputId = "textarea",
      label = "Text Area",
      value = "Lorem ipsum dolor sit amet, consectetur
       adipiscing elit, sed do eiusmod tempor incididunt ut
       labore et dolore magna aliqua",
      placeholder = "Your text here",
      resize = TRUE
     ),
     textOutput("value")
   ),
   server = function(input, output) {
     output$value <- renderText({ input$textarea })
   }
 )
}
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
   f7SingleLayout(
    navbar = f7Navbar(title = "updateF7TextArea"),
    f7Block(f7Button("trigger", "Click me")),
    f7TextArea(
     inputId = "textarea",
     label = "Text Area",
     value = "Lorem ipsum dolor sit amet, consectetur
              adipiscing elit, sed do eiusmod tempor incididunt ut
              labore et dolore magna aliqua",
     placeholder = "Your text here",
     resize = TRUE
     ),
    verbatimTextOutput("value")
   )
 )

 server <- function(input, output, session) {
   output$value <- renderPrint(input$textarea)
   observeEvent(input$trigger, {
     updateF7Text("textarea", value = "Updated Text")
   })
 }
shinyApp(ui, server)
}
}
