% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progressBars.R
\name{progressBar}
\alias{progressBar}
\title{Progress Bars}
\usage{
progressBar(id, value, total = NULL, display_pct = FALSE, size = NULL,
  status = NULL, striped = FALSE, title = NULL)
}
\arguments{
\item{id}{An id used to update the progress bar.}

\item{value}{Value of the progress bar between 0 and 100, if >100 you must provide total.}

\item{total}{Used to calculate percentage if value > 100, force an indicator to appear on top right of the progress bar.}

\item{display_pct}{logical, display percentage on the progress bar.}

\item{size}{Size, `NULL` by default or a value in 'xxs', 'xs', 'sm', only work with package `shinydashboard`.}

\item{status}{Color, must be a valid Bootstrap status : primary, info, success, warning, danger.}

\item{striped}{logical, add a striped effect.}

\item{title}{character, optional title.}
}
\value{
A progress bar that can be added to a UI definition.
}
\description{
Create a progress bar to provide feedback on calculation.
}
\examples{
\dontrun{
if (interactive()) {
 library("shiny")
 library("shinyWidgets")

 ui <- fluidPage(
   tags$b("Default"), br(),
   progressBar(id = "pb1", value = 50),
   sliderInput(inputId = "up1", label = "Update", min = 0, max = 100, value = 50)
 )

 server <- function(input, output, session) {
   observeEvent(input$up1, {
     updateProgressBar(session = session, id = "pb1", value = input$up1)
   })
 }

 shinyApp(ui = ui, server = server)
 }
}
}
