% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-sliderText.R
\name{updateSliderTextInput}
\alias{updateSliderTextInput}
\title{Change the value of a slider text input on the client}
\usage{
updateSliderTextInput(
  session,
  inputId,
  label = NULL,
  selected = NULL,
  choices = NULL,
  from_fixed = NULL,
  to_fixed = NULL
)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set.}

\item{selected}{The values selected.}

\item{choices}{The new choices for the input.}

\item{from_fixed}{Fix the left handle (or single handle).}

\item{to_fixed}{Fix the right handle.}
}
\description{
Change the value of a slider text input on the client
}
\examples{
if (interactive()) {
library("shiny")
library("shinyWidgets")

ui <- fluidPage(
  br(),
  sliderTextInput(
    inputId = "mySlider",
    label = "Pick a month :",
    choices = month.abb,
    selected = "Jan"
  ),
  verbatimTextOutput(outputId = "res"),
  radioButtons(
    inputId = "up",
    label = "Update choices:",
    choices = c("Abbreviations", "Full names")
  )
)

server <- function(input, output, session) {
  output$res <- renderPrint(str(input$mySlider))

  observeEvent(input$up, {
    choices <- switch(
      input$up,
      "Abbreviations" = month.abb,
      "Full names" = month.name
    )
    updateSliderTextInput(
      session = session,
      inputId = "mySlider",
      choices = choices
    )
  }, ignoreInit = TRUE)
}

shinyApp(ui = ui, server = server)
}
}
\seealso{
\code{\link{sliderTextInput}}
}
