% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-background.R
\name{setBackgroundImage}
\alias{setBackgroundImage}
\title{Custom background image for your shinyapp}
\usage{
setBackgroundImage(src = NULL, shinydashboard = FALSE)
}
\arguments{
\item{src}{Url or path to the image, if using local image,
the file must be in \code{www/} directory and the path not contain \code{www/}.}

\item{shinydashboard}{Set to \code{TRUE} if in a shinydasboard application.}
}
\description{
Allow to change the background image of your shinyapp.
}
\examples{
if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Add a shiny app background image"),
  setBackgroundImage(
    src = "https://www.fillmurray.com/1920/1080"
  )
)

server <- function(input, output, session) {

}

shinyApp(ui, server)

}

}
