% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useShinyalert.R
\name{useShinyalert}
\alias{useShinyalert}
\title{Set up a Shiny app to use shinyalert}
\usage{
useShinyalert(rmd, force = FALSE)
}
\arguments{
\item{rmd}{Deprecated, do not use this parameter.}

\item{force}{Set to \code{TRUE} to force pre-loading the {shinyalert} scripts. If
\code{FALSE} (default), you will get a warning saying this function is not required.}
}
\value{
Scripts that \code{shinyalert} requires that are automatically
inserted to the app's \code{<head>} tag.
}
\description{
\strong{This function is no longer required.}\cr\cr
The first time a {shinyalert} message is shown, the required scripts are
\emph{automatically} inserted to the Shiny app. Usually this is not an issue, but
in some unique cases this can sometimes cause the modal to appear glitchy
(such as inside RStudio's Viewer, on some old browsers, or if the modal contains
certain Shiny inputs).\cr\cr
If you notice issues with the UI of the modal, you may want to try to pre-load
the scripts when the Shiny app initializes by calling \code{useShinyalert(force=TRUE)}
anywhere in the UI.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyalert)

  shinyApp(
    ui = fluidPage(
      useShinyalert(force = TRUE),  # Set up shinyalert
      actionButton("btn", "Click me")
    ),
    server = function(input, output) {
      observeEvent(input$btn, {
        # Show a simple modal
        shinyalert(title = "You did it!", type = "success")
      })
    }
  )
}
}
\seealso{
\code{\link[shinyalert]{shinyalert}}
}
