% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-modal.R
\name{modal-spinner}
\alias{modal-spinner}
\alias{show_modal_spinner}
\alias{remove_modal_spinner}
\title{Show a modal with a spinner}
\usage{
show_modal_spinner(spin = "double-bounce", color = "#112446",
  text = NULL, session = shiny::getDefaultReactiveDomain())

remove_modal_spinner(session = getDefaultReactiveDomain())
}
\arguments{
\item{spin}{Style of the spinner, see \link{spin_epic} or \link{spin_kit} for possible choices.}

\item{color}{Color for the spinner, in a valid CSS format.}

\item{text}{Additional text to appear under the spinner.}

\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}
}
\description{
Make a pop-up window appear from the server
 with a spinner during long computation, remove it when finished.
}
\examples{
if (interactive()) {

  library(shiny)
  library(shinybusy)

  ui <- fluidPage(

    tags$h1("Modal with spinner"),
    actionButton("sleep1", "Launch a long calculation"),
    actionButton("sleep2", "And another one")
  )

  server <- function(input, output, session) {

    observeEvent(input$sleep1, {
      show_modal_spinner()
      Sys.sleep(5)
      remove_modal_spinner()
    })

    observeEvent(input$sleep2, {
      show_modal_spinner(
        spin = "cube-grid",
        color = "firebrick",
        text = "Please wait..."
      )
      Sys.sleep(5)
      remove_modal_spinner()
    })

  }

  shinyApp(ui, server)

}
}
