% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_js.R
\name{progress}
\alias{progress}
\alias{progress_line}
\alias{progress_circle}
\alias{progress_semicircle}
\alias{update_progress}
\title{Create progress indicator}
\usage{
progress_line(value = 0, color = "#112446", stroke_width = 4,
  easing = "linear", duration = 1000, trail_color = "#eee",
  trail_width = 1, text = "auto", text_color = "#000",
  width = "100\%", height = "15px", shiny_id = NULL)

progress_circle(value = 0, color = "#112446", stroke_width = 4,
  easing = "easeInOut", duration = 1400, trail_color = "#eee",
  trail_width = 1, text = "auto", text_color = "#000",
  width = "200px", height = "200px", shiny_id = NULL)

progress_semicircle(value = 0, color = "#112446", stroke_width = 4,
  easing = "easeInOut", duration = 1400, trail_color = "#eee",
  trail_width = 1, text = "auto", text_color = "#000",
  width = "200px", height = "100px", shiny_id = NULL)

update_progress(shiny_id, value, text = NULL,
  session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{value}{Initial value or new value to set.}

\item{color}{Main color.}

\item{stroke_width}{Main width.}

\item{easing}{CSS animation to use, ex.: \code{"linear"},
\code{"easeIn"}, \code{"easeOut"}, \code{"easeInOut"}.}

\item{duration}{Animation duration (in milliseconds).}

\item{trail_color}{Color of shape behind the main bar.}

\item{trail_width}{Width of shape behind the main bar.}

\item{text}{Text to display.}

\item{text_color}{Text color.}

\item{width}{Container width.}

\item{height}{Container height.}

\item{shiny_id}{Id to use in Shiny application.}

\item{session}{Shiny session.}
}
\value{
an \code{htmlwidget} object.
}
\description{
Bar, circle or semicircle to show progress.
 Can be used outside Shiny. In Shiny you can set
 progress value server-side.
}
