% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardSidebar.R
\name{dashboardSidebar}
\alias{dashboardSidebar}
\title{Create a dashboard sidebar.}
\usage{
dashboardSidebar(..., disable = FALSE, width = NULL)
}
\arguments{
\item{...}{Items to put in the sidebar.}

\item{disable}{If \code{TRUE}, the sidebar will be disabled.}

\item{width}{The width of the sidebar. This must either be a number which
specifies the width in pixels, or a string that specifies the width in CSS
units.}
}
\description{
A dashboard sidebar typically contains a \code{\link{sidebarMenu}}, although
it may also contain a \code{\link{sidebarSearchForm}}, or other Shiny inputs.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
header <- dashboardHeader()

sidebar <- dashboardSidebar(
  sidebarUserPanel("User Name",
    subtitle = a(href = "#", icon("circle", class = "text-success"), "Online"),
    # Image file should be in www/ subdir
    image = "userimage.png"
  ),
  sidebarSearchForm(label = "Enter a number", "searchText", "searchButton"),
  sidebarMenu(
    # Setting id makes input$tabs give the tabName of currently-selected tab
    id = "tabs",
    menuItem("Dashboard", tabName = "dashboard", icon = icon("dashboard")),
    menuItem("Widgets", icon = icon("th"), tabName = "widgets", badgeLabel = "new",
             badgeColor = "green"),
    menuItem("Charts", icon = icon("bar-chart-o"),
      menuSubItem("Sub-item 1", tabName = "subitem1"),
      menuSubItem("Sub-item 2", tabName = "subitem2")
    )
  )
)

body <- dashboardBody(
  tabItems(
    tabItem("dashboard",
      div(p("Dashboard tab content"))
    ),
    tabItem("widgets",
      "Widgets tab content"
    ),
    tabItem("subitem1",
      "Sub-item 1 tab content"
    ),
    tabItem("subitem2",
      "Sub-item 2 tab content"
    )
  )
)

shinyApp(
  ui = dashboardPage(header, sidebar, body),
  server = function(input, output) { }
)
}
}
\seealso{
\code{\link{sidebarMenu}}
}

