% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardHeader.R
\name{dashboardUser}
\alias{dashboardUser}
\title{Create a dashboard user profile.}
\usage{
dashboardUser(
  ...,
  name = NULL,
  image = NULL,
  title = NULL,
  subtitle = NULL,
  footer = NULL
)
}
\arguments{
\item{...}{Body content. Slot for \link{dashboardUserItem}.}

\item{name}{User name.}

\item{image}{User profile picture.}

\item{title}{A title.}

\item{subtitle}{A subtitle.}

\item{footer}{Footer is any.}
}
\description{
Create a dashboard user profile.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyWidgets)
  library(shinydashboard)
  library(shinydashboardPlus)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(userOutput("user")),
      sidebar = dashboardSidebar(),
      body = dashboardBody(),
      title = "DashboardPage"
    ),
    server = function(input, output) {
      output$user <- renderUser({
        dashboardUser(
          name = "Divad Nojnarg",
          image = "https://adminlte.io/themes/AdminLTE/dist/img/user2-160x160.jpg",
          title = "shinydashboardPlus",
          subtitle = "Author",
          footer = p("The footer", class = "text-center"),
          fluidRow(
            dashboardUserItem(
              width = 6,
              socialButton(
                href = "https://dropbox.com",
                icon = icon("dropbox")
              )
            ),
            dashboardUserItem(
              width = 6,
              socialButton(
                href = "https://github.com",
                icon = icon("github")
              )
            )
          )
        )
      })
    }
  )
}

}
\seealso{
\code{\link{userOutput}} and \code{\link{renderUser}} for
dynamically-generating \code{\link{dashboardUser}}.
}
