% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortableTabsetPanel.R
\name{sortableTabsetPanel}
\alias{sortableTabsetPanel}
\title{Create a tabset panel with sortable tabs}
\usage{
sortableTabsetPanel(..., id = NULL, selected = NULL, type = c("tabs",
  "pills"), position = NULL)
}
\arguments{
\item{...}{\code{\link{tabPanel}} elements to include in the tabset}

\item{id}{If provided, you can use \code{input$}\emph{\code{id}} in your
server logic to determine which of the current tabs is active. The value
will correspond to the \code{value} argument that is passed to
\code{\link{tabPanel}}.}

\item{selected}{The \code{value} (or, if none was supplied, the \code{title})
of the tab that should be selected by default. If \code{NULL}, the first
tab will be selected.}

\item{type}{Use "tabs" for the standard look; Use "pills" for a more plain
look where tabs are selected using a background fill color.}

\item{position}{This argument is deprecated; it has been discontinued in
Bootstrap 3.}
}
\value{
A tabset that can be passed to \link[shiny:mainPanel]{shiny::mainPanel}
}
\description{
Create a tabset that contains \link[shiny:tabPanel]{shiny::tabPanel} elements. The tabs are
sortable by drag and drop. In addition to the activated tab title stored in
\code{input$<id>}, the server will also receive the order of tabs in
\code{input$<id>_order}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  shinyApp(
    ui = fluidPage(
      sortableTabsetPanel(
        id = "tabs",
        tabPanel(title = "A", "AAA"),
        tabPanel(title = "B", "BBB"),
        tabPanel(title = "C", "CCC")
      ),
      verbatimTextOutput("order")
    ),
    server = function(input, output) {
      output$order <- renderPrint({input$tabs_order})
    }
  )
}

}
\seealso{
\link[shiny:tabsetPanel]{shiny::tabsetPanel}, \link{sortableRadioButtons},
\link{sortableCheckboxGroupInput}, \link{sortableTableOutput}
}
