% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disabled.R
\name{disabled}
\alias{disabled}
\title{Initialize a Shiny input as disabled}
\usage{
disabled(...)
}
\arguments{
\item{...}{Shiny input (or tagList or list of of tags that include inputs) to
disable.}
}
\value{
The tag (or tags) that was given as an argument in a disabled state.
}
\description{
Create a Shiny input that is disabled when the Shiny app starts. The input can
be enabled later with \code{shinyjs::toggleState} or \code{shinyjs::enable}.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
if (interactive()) {
  shiny::shinyApp(
    ui = shiny::fluidPage(
      useShinyjs(),  # Set up shinyjs
      shiny::actionButton("btn", "Click me"),
      disabled(
        shiny::textInput("element", NULL, "I was born disabled")
      )
    ),
    server = function(input, output) {
      shiny::observeEvent(input$btn, {
        enable("element")
      })
    }
  )
}

disabled(shiny::numericInput("num", NULL, 5), shiny::dateInput("date", NULL))
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{toggleState}},
\code{\link[shinyjs]{enable}},
\code{\link[shinyjs]{disable}}
}

