% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shoredate_sumplot.R
\name{shoredate_sumplot}
\alias{shoredate_sumplot}
\title{Plot the summed probability distribution of multiple shoreline dates}
\usage{
shoredate_sumplot(shoredates_sum, sample_size = TRUE)
}
\arguments{
\item{shoredates_sum}{Object of class \code{shoredates_sum}.}

\item{sample_size}{Logical indicating whether or not to display the number of
summed dates on the plot. Defaults to TRUE.}
}
\value{
A line plot showing the provided summed probability distribution.
}
\description{
Function to plot the sum of the probabilities of multiple shoreline dates as
resulting from running \code{sum_shoredates()}.
}
\examples{
target_points <- sf::st_sfc(sf::st_point(c(538310, 6544255)),
                            sf::st_point(c(538300, 6544250)))
target_points <- sf::st_as_sf(target_points, crs = 32632)

# Shoreline date, reducing resolution on elevation and calendar scales for
# speed.
target_dates <- shoreline_date(target_points,
                               elevation = c(65, 70),
                               elev_reso = 10,
                               cal_reso = 750)

target_sum <- sum_shoredates(target_dates)

shoredate_sumplot(target_sum)
}
