% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-timing-gates.R
\name{model_timing_gates}
\alias{model_timing_gates}
\alias{model_timing_gates_TC}
\alias{model_timing_gates_FD}
\alias{model_timing_gates_FD_TC}
\title{Models Using Timing Gates Split Times}
\usage{
model_timing_gates(
  distance,
  time,
  weights = 1,
  LOOCV = FALSE,
  control = minpack.lm::nls.lm.control(maxiter = 1000),
  na.rm = FALSE,
  ...
)

model_timing_gates_TC(
  distance,
  time,
  weights = 1,
  LOOCV = FALSE,
  control = minpack.lm::nls.lm.control(maxiter = 1000),
  na.rm = FALSE,
  ...
)

model_timing_gates_FD(
  distance,
  time,
  weights = 1,
  LOOCV = FALSE,
  control = minpack.lm::nls.lm.control(maxiter = 1000),
  na.rm = FALSE,
  ...
)

model_timing_gates_FD_TC(
  distance,
  time,
  weights = 1,
  LOOCV = FALSE,
  control = minpack.lm::nls.lm.control(maxiter = 1000),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{distance, time}{Numeric vector. Indicates the position of the timing gates and time measured}

\item{weights}{Numeric vector. Default is vector of 1.
This is used to give more weight to particular observations. For example, use \code{1\\distance} to give
more weight to observations from shorter distances.}

\item{LOOCV}{Should Leave-one-out cross-validation be used to estimate model fit? Default is \code{FALSE}}

\item{control}{Control object forwarded to \code{\link[minpack.lm]{nlsLM}}. Default is \code{minpack.lm::nls.lm.control(maxiter = 1000)}}

\item{na.rm}{Logical. Default is FALSE}

\item{...}{Extra parameters forwarded to \code{\link[minpack.lm]{nlsLM}} function}
}
\value{
List object with the following elements:
    \describe{
        \item{data}{Data frame used to estimate the sprint parameters, consisting of \code{distance},
            \code{time}, \code{weights}, and \code{pred_time} columns}
        \item{model}{Model returned by the \code{\link[minpack.lm]{nlsLM}} function}
        \item{parameters}{List with the estimated parameters, of which the following
        are always returned: \code{MSS}, \code{TAU}, \code{MAC}, and \code{PMAX}}
        \item{model_fit}{List with the following components:
            \code{RSE}, \code{R_squared}, \code{minErr}, \code{maxErr}, and \code{RMSE}}
        }
}
\description{
These functions model the sprint split times using mono-exponential equation, where \code{time}
    is used as target or outcome variable, and \code{distance} as predictor.
    \itemize{
    \item{\code{\link{model_timing_gates}}}{ Provides the simplest model with estimated \code{MSS}
     and \code{MAC} parameters}
    \item{\code{\link{model_timing_gates_TC}}}{ Besides estimating \code{MSS} and \code{MAC}
    parameters, this function estimates additional parameter \code{TC} or time correction}
    \item{\code{\link{model_timing_gates_FD}}}{ In addition to estimating \code{MSS} and
     \code{MAC} parameters, this function estimates \code{FD} or flying distance}
    \item{\code{\link{model_timing_gates_FD_TC}}}{ Combines the approach of the \code{\link{model_timing_gates_FD}} with
    that one of \code{\link{model_timing_gates_TC}}. In other words, it add extra parameter \code{TC} to be estimated in
    the \code{\link{model_timing_gates_FD}} model}
    }
}
\examples{
split_distances <- c(10, 20, 30, 40, 50)
split_times <- create_timing_gates_splits(
  gates = split_distances,
  MSS = 10,
  MAC = 9,
  FD = 0.25,
  TC = 0
)

# Simple model
simple_model <- model_timing_gates(split_distances, split_times)

print(simple_model)
coef(simple_model)
plot(simple_model)

# Model with correction of 0.3s
model_with_correction <- model_timing_gates(split_distances, split_times + 0.3)

print(model_with_correction)
plot(model_with_correction)

# Model with time_correction estimation
model_with_TC <- model_timing_gates_TC(split_distances, split_times)

print(model_with_TC)
plot(model_with_TC)

# Model with flying distance estimations
model_with_FD <- model_timing_gates_FD(split_distances, split_times)

print(model_with_FD)
plot(model_with_FD)

# Model with flying distance estimations and time correction
model_with_FD_TC <- model_timing_gates_FD_TC(split_distances, split_times)

print(model_with_FD_TC)
plot(model_with_FD_TC)
}
\references{
Haugen TA, Tønnessen E, Seiler SK. 2012. The Difference Is in the Start: Impact of Timing and Start
        Procedure on Sprint Running Performance: Journal of Strength and Conditioning Research 26:473–479.
        DOI: 10.1519/JSC.0b013e318226030b.

    Jovanović, M., Vescovi, J.D. (2020). shorts: An R Package for Modeling Short Sprints. Preprint
        available at SportRxiv. https://doi.org/10.31236/osf.io/4jw62
}
