% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_shrinkDSM.R
\name{divisionpoints}
\alias{divisionpoints}
\title{Create division points for estimation of a dynamic survival model}
\usage{
divisionpoints(times, delta, events = 1)
}
\arguments{
\item{times}{A vector of real, positive numbers indicating
the survival times. For right censored data, this is the follow up time.}

\item{delta}{A vector of status indicators, with 0 = alive and 1 = dead.
Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} = death) or 1/2 (2 = death).}

\item{events}{A positive integer indicating the number of interesting events per interval until
a new division is created.}
}
\value{
Returns an integer vector of time points to be used as division points \code{S} in \code{shrinkDSM}.
}
\description{
Create a vector of division points for the model.
These points mark the times at which the parameters are allowed to evolve,
with the parameters being fixed between division points. The points
are generated in a data driven fashion, with a new point being created
when \code{events} number of interesting events have been observed since
the last division point.
}
\examples{
data("gastric")

# Create intervals for piecewise exponential model
intervals <- divisionpoints(gastric$time, gastric$status, 2)
}
\author{
Daniel Winkler \email{daniel.winkler@wu.ac.at}
}
