% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkTVPVAR_methods.R
\name{fitted.shrinkTVPVAR}
\alias{fitted.shrinkTVPVAR}
\title{Calculate fitted historical values for an estimated TVP-VAR-SV model}
\usage{
\method{fitted}{shrinkTVPVAR}(object, ...)
}
\arguments{
\item{object}{A \code{shrinkTVPVAR} object}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{shrinkTVPVAR_fit}
}
\description{
Calculates the fitted values for an estimated TVP-VAR-SV model.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVPVAR(p = 2)
data <- sim$data

res <- shrinkTVPVAR(data, p = 2)
fitted <- fitted(res)

# Visualize fitted values
plot(fitted)
}
}
\seealso{
Other prediction functions: 
\code{\link{forecast_shrinkTVPVAR}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{prediction functions}
