% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_query.R
\name{clean_query}
\alias{clean_query}
\title{Clean Query}
\usage{
clean_query(request, try_simplify = TRUE)
}
\arguments{
\item{request}{The request output from get_query_from_token()}

\item{try_simplify}{because requests can return JSON and may not have the same length
across values, they may not be data frame compliant (all columns having the same number of rows).
A key example would be TX_JSON in EVM FACT_TRANSACTION tables which include 50+
extra details from transaction logs. But other examples like NULLs in TO_ADDRESS can have similar
issues. Default TRUE.}
}
\value{
A data frame. If `try_simplify` is FALSE OR if `try_simplify` TRUE fails:
the data frame is comprised of lists, where each column must be coerced
to a desired class (e.g., with `as.numeric()`).
}
\description{
Converts query response to data frame while attempting to coerce classes
intelligently.
}
\examples{
\dontrun{
query <- create_query_token("SELECT * FROM ETHEREUM.CORE.FACT_TRANSACTIONS LIMIT 1000", api_key)
request <- get_query_from_token(query$result$queryRequest$queryRunId, api_key)
df1 <- clean_query(request, try_simplify = TRUE)
}
}
