% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjecture.R
\name{conjecture}
\alias{conjecture}
\title{Specialized "long to wide" reshaping}
\usage{
conjecture(data, sort_by, names_from, names_first)
}
\arguments{
\item{data}{A data frame to reshape.}

\item{sort_by}{Column name, as symbol. Plays a similar role as \code{values_from} in \code{pivot_wider()}, but also serves as sorting dimension for underlying conjecture algorithm.}

\item{names_from}{Column name, as symbol. Used to differentiate anterior/posterior observations. Column must only contain 2 levels (missing values not allowed).}

\item{names_first}{level in variable specified by \code{names_from} indicating anterior observation.}
}
\value{
An object of the same type as \code{data}.
}
\description{
On the surface, \code{conjecture()} appears similar to \code{tidyr::pivot_wider()}, but uses different logic tailored to a specific type of dataset:

\itemize{
  \item{column corresponding to \code{names_from} contains only 2 levels}
  \item{there is no determinate combination of elements to fill 2 columns per row}.
}

See vignette("conjecture") for more details.
}
\details{
\code{conjecture()} uses the following routine to match elements:

\enumerate{
  \item{Values in \code{sort_by} are separated into two vectors: anterior and posterior.}
  \item{Each anterior element is matched with the closest posterior element measured by \code{sort_by}.}
}
}
\examples{
# See vignette("conjecture") for more examples

conjecture(comms, timestamp, type, "send")
}
