% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_save_dictionary.R
\name{save_dictionary}
\alias{save_dictionary}
\title{Save a dataframe's dictionary to a file}
\usage{
save_dictionary(df, path = stop("'path' must be specified."), ...)
}
\arguments{
\item{df}{(Dataframe) The dataframe whose dictionary you want to save.}

\item{path}{(Character) The path to save the dictionary to. The dictionary's
files will be put into a new subfolder called \code{"{df}_dictionary"}.}

\item{...}{(Dots) Other named arguments that will be passed to \code{\link[utils:write.table]{utils::write.table()}}.}
}
\value{
Returns nothing, but prints a message announcing where the dictionary
was saved. In an interactive session, it also opens that location in
your file explorer.
}
\description{
Saves a data dictionary in a form that is usable by my dataframe
labelling package, \href{https://github.com/DesiQuintans/tsv2label}{\code{tsv2label}}.

This function creates a folder called \code{"{df name}_dictionary"} that contains
a file called \code{index.tsv} and other files that contain factor level
definitions. \emph{The folder itself} is the data dictionary, and \code{tsv2label}
looks inside it to do its labelling.

Under normal circumstances you would simply save the dataframe using
\code{\link[=saveRDS]{saveRDS()}} or \code{\link[=save]{save()}}, both of which save the dataframe exactly as it is,
including all of its labels and types.
However, there are times when you need to keep the dataframe in a format that
won't save its metadata. For example:
\enumerate{
\item You want to export the dataframe to a CSV to share it with others.
\item You need to keep the data in a particular format to take advantage of
another R package, and that package does not save metadata. For example,
maybe you're working with very large data and you want to keep it in CSV
to take advantage of \code{vroom}, or in FST to take advantage of \code{fst}.
\item You are accessing the data remotely (e.g. building it from API calls) and
you need to relabel it every time.
}
}
\examples{
\donttest{
save_dictionary(iris, path = tempdir())
}

}
