% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_series.R
\name{get_cnsummary_sample}
\alias{get_cnsummary_sample}
\title{Get summary of copy number variation per sample}
\usage{
get_cnsummary_sample(segTab, genome_build = c("hg19", "hg38"),
  genome_measure = c("called", "wg"), min_seg_len = 1000L)
}
\arguments{
\item{segTab}{a \code{data.frame} with 'chromosome', 'start', 'end' and 'segVal'
and 'sample' these five ordered columns. 'chromosome' should have prefix "chr".}

\item{genome_build}{genome build version, should be 'hg19' or 'hg38'.}

\item{genome_measure}{default is 'called', can be 'wg' or 'called'.
Set 'called' will use autosomo called segments size to compute total size for CNA burden calculation,
this option is useful for WES and target sequencing.
Set 'wg' will use autosome size from genome build, this option is useful for WGS, SNP etc..}

\item{min_seg_len}{minimal length of CNV segment for CNA burden calculation,
default is 1000. (!NOT implement NOW!)}
}
\value{
a data table
}
\description{
Include number of CNV segments, CNA burden, number of CNV amplification segments,
number of CNV deletion segments etc..
}
\details{
CNA burden, a simple metric of CNA level defined as the percent of the
autosomal tumor genome bearing CNAs, could be used as an informative measure of CNA.
}
\examples{
\donttest{
load(system.file("extdata", "example_cn_list.RData",
  package = "sigminer", mustWork = TRUE
))
segTabs <- data.table::rbindlist(tcga_segTabs, idcol = "sample")
segTabs$chromosome <- paste0("chr", segTabs$chromosome)
samp_sum <- get_cnsummary_sample(segTabs[, c(2:5, 1)])
}
}
\references{
Hieronymus, Haley, et al. "Copy number alteration burden predicts prostate cancer relapse." Proceedings of the National Academy of Sciences 111.30 (2014): 11139-11144.
}
\seealso{
Other internal calculation function series: \code{\link{get_ArmLocation}},
  \code{\link{get_LengthFraction}},
  \code{\link{get_cnlist}}, \code{\link{get_components}},
  \code{\link{get_features}}, \code{\link{get_matrix}}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
\concept{internal calculation function series}
