% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cn_freq_table.R
\name{get_cn_freq_table}
\alias{get_cn_freq_table}
\title{Get CNV Frequency Table}
\usage{
get_cn_freq_table(
  data,
  genome_build = "hg19",
  cutoff = 2L,
  resolution_factor = 1L
)
}
\arguments{
\item{data}{a \code{CopyNumber} object or a data.frame containing
at least 'chromosome', 'start', 'end', 'segVal', 'sample' these columns.}

\item{genome_build}{genome build version, used when \code{data} is a \code{data.frame}, should be 'hg19' or 'hg38'.}

\item{cutoff}{copy number value cutoff for splitting data into AMP and DEL.
The values equal to cutoff are discarded. Default is \code{2}, you can also set
a length-2 vector, e.g. \code{c(2, 2)}.}

\item{resolution_factor}{an integer to control the resolution.
When it is \code{1} (default), compute frequency in each cytoband.
When it is \code{2}, use compute frequency in each half cytoband.}
}
\value{
a \code{data.table}.
}
\description{
Get CNV Frequency Table
}
