% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_k_mer_state.R
\name{add_k_mer_state}
\alias{add_k_mer_state}
\title{Adds k-mer hidden state to signalHsmm model}
\usage{
add_k_mer_state(kMer, pipar, tpmpar, od, params, pState, nState, pTrans, d)
}
\arguments{
\item{kMer}{\code{character} vector representing k-mer aminoacid sequence.}

\item{pipar}{Probabilities of initial state in Markov Model.}

\item{tpmpar}{Matrix with transition probabilities between states.}

\item{od}{Matrix of response probabilities. Eg. od[1,2] is a 
probability of signal 2 in state 1.}

\item{params}{Matrix of probability distribution for duration.
Eg. params[10,2] is probability of duration of time 10 in state 2.}

\item{pState}{number denoting hidden state right before k-mer.}

\item{nState}{number denoting hidden state right after k-mer.}

\item{pTrans}{Probability of change from pState to k-mer hidden state.}

\item{d}{Duration of the state.}
}
\value{
A list of length four:
\itemize{
\item{pipar}{ a vector of new probabilities of initial state in Markov Model,}
\item{tpmpar}{ a matrix with new transition probabilities between states,}
\item{od}{ matrix of new response probabilities,}
\item{params}{ matrix of new probability distributions for duration.}
}
}
\description{
Changes parameters for Hidden Semi-Markov Model to
add k-mer
}
\note{
Currently add only k-mers without distance.
}

