% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorTest.R
\name{render.sigr_cortest}
\alias{render.sigr_cortest}
\title{Format cor.test (test of liner correlation).}
\usage{
\method{render}{sigr_cortest}(statistic, ..., format, statDigits = 2,
  sigDigits = 2, pLargeCutoff = 0.05, pSmallCutoff = 1e-05)
}
\arguments{
\item{statistic}{wrapped cor.test.}

\item{...}{extra arguments (not used)}

\item{format}{if set the format to return ("html", "latex", "markdown", "ascii", "docx", ...)}

\item{statDigits}{integer number of digits to show in summaries.}

\item{sigDigits}{integer number of digits to show in significances.}

\item{pLargeCutoff}{value to declare non-significance at or above.}

\item{pSmallCutoff}{smallest value to print}
}
\value{
formatted string
}
\description{
Format cor.test (test of liner correlation).
}
\examples{

d <- data.frame(x=c(1,2,3,4,5,6,7,7),
                y=c(1,1,2,2,3,3,4,4))
ct <- cor.test(d$x,d$y)
wrapCorTest(ct)


}
