% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_uid.R
\name{sc_uid}
\alias{sc_uid}
\title{Unique labels}
\usage{
sc_uid(x, ..., uid_nchar = NULL)
}
\arguments{
\item{x}{number of unique IDs to generate}

\item{...}{reserved for future use}

\item{uid_nchar}{number of raw characters to paste as a uuid, default is 6 (only if silicate.uid.type is "uuid", see Details)}
}
\value{
vector of unique id values for elements in the input
}
\description{
Find unique labels for entities, or create them
if not present.
}
\details{
If 'integers' default we generate sequential integers, it's assumed that all IDs are created
at one time, we are not adding to an existing set. Code that adds IDs should find
the largest existing ID and offset these by that value.

Using 'silicate.uid.type="uuid"' is the default. Using 'silicate.uid.type="integer"' is considered experimental.
By default UIDs are a mix of letters, LETTERS and digits of length \code{getOption("silicate.uid.size")} which defaults to 6.

See \code{ids} package for \code{random_id} used if option 'silicate.uid.type="uuid"'.
}
\examples{
sc_uid(data.frame(1:10))
}
