% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vpois}
\alias{vpois}
\title{Variate Generation for Poisson Distribution}
\usage{
vpois(n, lambda, stream = NULL, antithetic = FALSE, asList = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{lambda}{Rate of distribution}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via
\code{\link[=qpois]{stats::qpois}};
otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qpois]{stats::qpois}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

Otherwise, return a list with components suitable for visualizing inversion,
specifically:
\item{u}{        A vector of generated U(0,1) variates }
\item{x}{        A vector of Poisson random variates }
\item{quantile}{ Parameterized quantile function }
\item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Poisson Distribution
}
\details{
Generates random variates from the Poisson distribution.

Poisson variates are generated by inverting uniform(0,1) variates
produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
\code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}}
(if \code{stream} is not \code{NULL}).
In either case, \code{\link[=qpois]{stats::qpois}} is used to
invert the uniform(0,1) variate(s).
In this way, using \code{vpois} provides a monotone and synchronized
binomial variate generator, although not particularly fast.

The stream indicated must be an integer between 1 and 25 inclusive.

The Poisson distribution has density
\deqn{p(x) = \frac{\lambda^x e^{-\lambda}}{x!}}{%
           p(x) = \lambda^x exp(-\lambda)/x!}
for \eqn{x = 0, 1, 2, \ldots}.
The mean and variance are \eqn{E(X) = Var(X) = \lambda}{E(X) = Var(X) = \lambda}
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qpois
 vpois(3, lambda = 5)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qpois
 vpois(3, 3, stream = 1)
 vpois(3, 3, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qpois
 vpois(1, 3, stream = 1)
 vpois(1, 3, stream = 2)
 vpois(1, 3, stream = 1)
 vpois(1, 3, stream = 2)
 vpois(1, 3, stream = 1)
 vpois(1, 3, stream = 2)

 set.seed(8675309)
 variates <- vpois(100, 3, stream = 1)
 set.seed(8675309)
 variates <- vpois(100, 3, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link{rstream}}, \code{\link{set.seed}},
\code{\link[=runif]{stats::runif}}

\code{\link[=rpois]{stats::rpois}}
}
\author{
Barry Lawson (\email{blawson@bates.edu}), \cr
Larry Leemis (\email{leemis@math.wm.edu}), \cr
Vadim Kudlay (\email{vkudlay@nvidia.com})
}
\concept{random variate generation}
\keyword{distribution}
