% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitionParameters.R
\name{weibull_transition}
\alias{weibull_transition}
\title{Transition Hazards for Weibull Distributed Event Times}
\usage{
weibull_transition(h01, h02, h12, p01, p02, p12)
}
\arguments{
\item{h01}{(positive \code{number})\cr transition hazard for 0 to 1 transition}

\item{h02}{(positive \code{number})\cr transition hazard for 0 to 2 transition}

\item{h12}{(positive \code{number})\cr transition hazard for 1 to 2 transition}

\item{p01}{(positive \code{number})\cr rate parameter of Weibull distribution for \code{h01}}

\item{p02}{(positive \code{number})\cr rate parameter of Weibull distribution for \code{h02}}

\item{p12}{(positive \code{number})\cr rate parameter of Weibull distribution for \code{h12}}
}
\value{
List with elements \code{hazards}, \code{intervals}, \code{weibull_rates} and \code{family}
(Weibull).
}
\description{
This creates a list with class \code{TransitionParameters} containing
hazards, time intervals and Weibull rates for Weibull distributed event times
in an illness-death model.
}
\examples{
weibull_transition(h01 = 1, h02 = 1.3, h12 = 0.5, p01 = 1.2, p02 = 1.3, p12 = 0.5)
}
