% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLife.R
\name{woehlerDiagram}
\alias{woehlerDiagram}
\title{Plot Woehler diagram}
\usage{
woehlerDiagram(W, yrange = NULL, cols = c("#0000FF", "#00FF00", "#FF0000",
  "#FF00FF", "#FFFF00", "#00FFFF"), syms = c(0, 1, 2, 5, 6),
  main = "Woehler experiment", ...)
}
\arguments{
\item{W}{results from function \code{\link{woehler}}}

\item{yrange}{range of stress levels, the min/max values of stress levels (default)}

\item{cols}{vector of colors, possibly being replicated}

\item{syms}{vector of symbol ids, see \code{pch} from \code{\link{par}}}

\item{main}{main title of the plot}

\item{...}{graphic parameters passed to function \code{\link{points}}}
}
\value{
\code{NULL}
}
\description{
Plot a Woehler diagram for simulated Woehler experiments
}
\details{
The simulated results of the Woehler experiments are summarized in 
the load-cycle diagram as usually done in the Woehler diagram.
The arguments of \code{syms} and \code{cols} are recycled if \code{nsim} 
exceeds one of their lengths.
}

