% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{eval_sites_deprecated}
\alias{eval_sites_deprecated}
\title{Evaluate sites.}
\usage{
eval_sites_deprecated(df_sim_sites, r_sim_sites)
}
\arguments{
\item{df_sim_sites}{dataframe generated by \code{\link[=sim_sites]{sim_sites()}}}

\item{r_sim_sites}{integer, number of repeats for bootstrap resampling for site
simulation, needed for zero probability correction for fp calculation, Default: 1000}
}
\value{
dataframe with the following columns:
\describe{
\item{\strong{study_id}}{study identification}
\item{\strong{site_number}}{site identification}
\item{\strong{visit_med75}}{median(max(visit)) * 0.75}
\item{\strong{mean_ae_site_med75}}{mean AE at visit_med75 site level}
\item{\strong{mean_ae_study_med75}}{mean AE at visit_med75 study level}
\item{\strong{pval}}{p-value as returned by \code{poisson.test}}
\item{\strong{prob_low}}{bootstrapped probability for having mean_ae_site_med75 or lower}
\item{\strong{n_site}}{number of study sites}
\item{\strong{pval_n_detected}}{sites with the same p-value or lower}
\item{\strong{pval_fp}}{expected number of fp, pval * n_site}
\item{\strong{pval_p_vs_fp_ratio}}{odds under-reporting as p/fp, poisson.test (use as benchmark)}
\item{\strong{pval_prob_ur}}{probability under-reporting as 1 - fp/p, poisson.test (use as benchmark)}
\item{\strong{prob_low_n_detected}}{sites with same bootstrapped probability or lower}
\item{\strong{prob_low_fp}}{expected number of fp, prob_lower * n_site}
\item{\strong{prob_low_p_vs_fp_ratio}}{odds under-reporting as p/fp, bootstrapped (use)}
\item{\strong{prob_low_prob_ur}}{probability under-reporting as 1 - fp/p, bootstrapped (use)}
}
}
\description{
Correct under-reporting probabilities by the expected number of
false positives (fp). This has been deprecated in favor of more conventional
methods available via \code{\link[stats]{p.adjust}}.
}
\details{
If by chance expected number of
false positives (fp) is greater than the total number of positives (p) we
set p_vs_fp_ratio = 1 and prob_ur = 0.
}
\examples{
df_visit <- sim_test_data_study(n_pat = 100, n_sites = 5,
    frac_site_with_ur = 0.4, ur_rate = 0.6)

df_visit$study_id <- "A"
df_site <- site_aggr(df_visit)

df_sim_sites <- sim_sites(df_site, df_visit, r = 100)

df_eval <- eval_sites_deprecated(df_sim_sites, r_sim_sites = 100)
df_eval
}
\seealso{
\code{\link[=site_aggr]{site_aggr()}}, \code{\link[=sim_sites]{sim_sites()}}
}
