% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfa_get_prices.R
\name{sfa_get_prices}
\alias{sfa_get_prices}
\title{Get price data}
\usage{
sfa_get_prices(
  ticker = NULL,
  simfin_id = NULL,
  ratios = NULL,
  start = NULL,
  end = NULL,
  api_key = getOption("sfa_api_key"),
  cache_dir = getOption("sfa_cache_dir"),
  sfplus = getOption("sfa_sfplus", default = FALSE)
)
}
\arguments{
\item{ticker}{\link{integer} Ticker of the companies of interest.}

\item{simfin_id}{\link{integer} 'SimFin' IDs of the companies of interest. Any
\code{simfin_id} will be internally translated to the respective \code{ticker}. This
reduces the number of queries in case you query the same company via
\code{ticker} \emph{and} \code{simfin_id}.}

\item{ratios}{\link{logical} With \code{TRUE}, you can display some price related
ratios along with the share price data (reserved for SimFin+ users). The
ratios that will be displayed are:
\itemize{
\item Market-Cap
\item Price to Earnings Ratio (quarterly)
\item Price to Earnings Ratio (ttm)
\item Price to Sales Ratio (quarterly)
\item Price to Sales Ratio (ttm)
\item Price to Book Value (ttm)
\item Price to Free Cash Flow (quarterly)
\item Price to Free Cash Flow (ttm)
\item Enterprise Value (ttm)
\item EV/EBITDA (ttm)
\item EV/Sales (ttm)
\item EV/FCF (ttm)
\item Book to Market Value (ttm)
\item Operating Income/EV (ttm).
}}

\item{start}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending AFTER the specified
date.}

\item{end}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending BEFORE the specified
date.}

\item{api_key}{\link{character} Your 'SimFin' API key. It's recommended to set
the API key globally using \link{sfa_set_api_key}.}

\item{cache_dir}{\link{character} Your cache directory. It's recommended to set
the cache directory globally using \link{sfa_set_cache_dir}.}

\item{sfplus}{\link{logical} Set\code{TRUE} if you have a SimFin+ account. It's
recommended to set \code{sfplus} globally using \link{sfa_set_sfplus}.}
}
\description{
Share price data and ratios can be retrieved here. All share
prices are adjusted for stock splits. If you are interested in more
details, take a look at this page:
https://www.simfin.com/data/help/main?topic=apiv2-prices
}
\section{Parallel processing}{

This function supports parallel processing via \code{future.apply}. If your
machine has several cores (most have), you can make the API calls in
parallel. To do so, define a \code{future::plan()} before calling the function.
}

