% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desireVar.r
\name{desireVar}
\alias{desireVar}
\title{Computes mixture normal variance}
\usage{
desireVar(desVar, num_dist, means, equalWeight = TRUE)
}
\arguments{
\item{desVar}{Desired overall variance of mixture normal distribution.}

\item{num_dist}{Number of normal distributions.}

\item{means}{Vector of means for each normal distribution. 
Must equal num_dist.}

\item{equalWeight}{Should equal weights be used, 
only TRUE is currently supported.}
}
\description{
Input the desired variance, number of distributions, and mean of the 
distributions, returns a value of the variance of each mixture distribution.
}
\details{
This function can be used to generate the inputs for the \code{\link{rbimod}} 
variances when a specific variance is desired.  Especially useful when 
attempting to simulate a mixture normal/bimodal distribution.
}
\examples{
\donttest{
# calculating variance to be 2.5 with 2 distributions
desireVar(2.5, 2, means = c(-1, 1), equalWeight = TRUE)
}
}
