% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixef_sim.r
\name{sim_fixef_nested3}
\alias{sim_fixef_nested3}
\title{Simulates design matrix.}
\usage{
sim_fixef_nested3(
  fixed,
  fixed_vars,
  cov_param,
  k,
  n,
  p,
  data_str,
  cor_vars = NULL,
  fact_vars = list(NULL),
  contrasts = NULL,
  knot_args = list(NULL)
)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation.}

\item{fixed_vars}{Character vector of covariates for design matrix.}

\item{cov_param}{List of arguments. Required arguments are:
 \itemize{
   \item dist_fun: This is a quoted R distribution function.
   \item var_type: This is the level of variable to generate. Must be 
     either 'level1', 'level2', or 'level3'. Must be same order as fixed formula 
     above.
 }
 Optional arguments to the distribution functions are in a nested list,
  see the examples for example code for this.
Does not include intercept, time, factors, or interactions.}

\item{k}{Number of third level clusters.}

\item{n}{Number of clusters.}

\item{p}{Number of within cluster units.}

\item{data_str}{Type of data. Must be "cross", or "long".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels = Number of levels for ordinal or factor variables.
     \item var_type = Must be 'level1', 'level2', or 'level3'.
 }
 Optional arguments passed on to sample in a nested list. These include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{contrasts}{An optional list that specifies the contrasts to be used for factor
variables (i.e. those variables with .f or .c). See \code{\link{contrasts}} for 
more detail.}

\item{knot_args}{A nested list of named knot arguments. See \code{\link{sim_knot}} 
for more details. Arguments must include:
  \itemize{
    \item var
    \item knot_locations
  }}
}
\description{
Input fixed variables, sample size, and number of within variables, returns 
design matrix.
}
\details{
Simulates the fixed effects for the \code{\link{sim_reg}} function when a 
linear mixed model is specified.  This function assumes a time variable when 
longitudinal data is specified and does include any interactions that are 
specified.
}
